function DoDamage(thiss,other)
{

	if (other.dex < 0) other_dex_bonus = 0
	else { other_dex_bonus = other.dex }
	
	if (thiss.dex < 0) this_dex_bonus = 0
	else { this_dex_bonus = thiss.dex }	

	low = ( other.str+(other_dex_bonus/4) - ( this_dex_bonus+(thiss.str/3) ) ) + Random(0,other.lck)
	hi = ( other.str+(other_dex_bonus/3) - ( (this_dex_bonus/2) + (thiss.str/4) ) ) - Random(0,thiss.lck)
	if (low < 0) low = 0
	if (hi < 0) hi = 0
	//Abort(low+"-"+hi)
	hi = Math.floor(hi)
	low = Math.floor(low)
	damage = Random(low,hi)
	
	thiss.hp -= damage
	Particles.push( new Particle(GetPersonX(thiss.name),GetPersonY(thiss.name),
											0,Random(-1,-4),1,damage,pFlyUp))
	thiss.invincible = true
}

function DoNothing() { }

/*
-----------------------------------------
|
| PLAYER
|
-----------------------------------------
*/

function ePlayerTouch(other)
{
	other.touch(this)
}

function ePlayerHurt(other)
{
	if (this.invincible == false)
		{
			DoDamage(this,other)
		}
										
	if (this.velocity_x != 0 || this.velocity_y != 0) 
		{
			if (this.velocity_x > 0) this.velocity_x = -10
			else { if (this.velocity_x < 0) this.velocity_x = 10 }
			
			if (this.velocity_y > 0) this.velocity_y = -10
			else { if (this.velocity_y < 0) this.velocity_y = 10 }											
		}
	else
		{
			switch (GetPersonDirection(other.name))
				{	
					case "south":
						this.velocity_y = -10
					break; 
					
					case "north":
						this.velocity_y = 10
					break; 
					case "west":
						this.velocity_x = 10
					break; 
					case "east":
						this.velocity_x = -10
					break;													
				}										
		}
											
}

function ePlayerUpdate()
{
	if (this.hp <= 0) { this.dead = true }
								
	if (this.invincible == true)
		{
			if (Math.sin(GetTime()>>6) > 0)
				{								 
					SetPersonMask(this.name, CreateColor(255,128,128))
				}
			else
				{
					SetPersonMask(this.name, CreateColor(255,255,255))
				}										
			this.invincible_time++;
			if (this.invincible_time >= 30) 
				{
					this.invincible = false; 
					this.invincible_time = 0;
				}
		}
	else
		{
			SetPersonMask(this.name, CreateColor(255,255,255))
		}
}

/*
-----------------------------------------
|
| NPC
|
-----------------------------------------
*/

function eBedTouch(other)
{
	if (other.name == People[Player].name)
		{
			if (this.invincible == false)
				{
					this.invincible = true;
					switch (ChoiceBox(["Go to sleep","Save Game","Stay awake"]))
						{
							case -1:
								RestockShops()
								Day++
								Trips = 3;
								People[Player].hp = People[Player].getMaxHP()
								FadeOut(2000)
								FadeIn(2000)
							break;
							case 0:
								SaveMenu()
							break;
						}
				}
		}
}

function eNPCTouch(other)
{
	if (other.name == People[Player].name)
		{
			if (this.invincible == false)
				{
					this.invincible = true;
					switch (this.name)
						{
							case "Oliver":
								switch (GetPlayerLevel())
									{
										case 0: Text([0]) 
										break;
										case 1: Text([1]) 
										break;
										case 2: Text([2]) 
										break;
										case 3: Text([3]) 
										break;								
									}
								
								p = FindPersonNumber(this.name)
								o = true
								while (o)
									{
										switch (ChoiceBox(["Buy","Sell","Leave"]))
											{
												case -1:
													BuyMenu(p)
												break;
												
												case 0:
													SellMenu(p)
												break;
												
												case 1:
													o = false
												break;
											}
									}
								
							break;
							case "Bob":
								switch (GetPlayerLevel())
									{
										case 0: Text([4]) 
										break;
										case 1: Text([5]) 
										break;
										case 2: Text([6]) 
										break;
										case 3: Text([7]) 
										break;								
									}					
							break;
							case "Nathaniel":
								switch (GetPlayerLevel())
									{
										case 0: Text([8]) 
										break;
										case 1: Text([9]) 
										break;
										case 2: Text([10]) 
										break;
										case 3: Text([11]) 
										break;								
									}					
							break;
							case "Elder":
								switch (GetPlayerLevel())
									{
										case 0: Text([12]) 
										break;
										case 1: Text([13]) 
										break;
										case 2: Text([14,15]) 
										break;
										case 3: Text([16]) 
										break;								
									}					
							break;	
							case "Sonja":
								switch (GetPlayerLevel())
									{
										case 0: Text([17]) 
										break;
										case 1: Text([18]) 
										break;
										case 2: Text([19]) 
										break;
										case 3: Text([20]) 
										break;								
									}					
							break;	
							case "Wolfgang":
								switch (GetPlayerLevel())
									{
										case 0: Text([21]) 
										break;
										case 1: Text([22]) 
										break;
										case 2: Text([23]) 
										break;
										case 3: Text([24]) 
										break;								
									}
								p = FindPersonNumber(this.name)
								o = true
								while (o)
									{
										switch (ChoiceBox(["Build","Buy","Sell","Leave"]))
											{
												case -1:
													Build()
												break;
												
												case 0:
													BuyMenu(p)
												break;
												
												case 1:
													SellMenu(p)
												break;
												
												case 2:
													o = false
												break;
											}
									}														
							break;																				
						}
						
				}
		}
	
}

function eNPCHurt()
{

}

function eNPCUpdate()
{
	if (this.invincible == true)
		{								
			this.invincible_time++;
			if (this.invincible_time >= 30) 
				{
					this.invincible = false; 
					this.invincible_time = 0;
				}
		}
}

/*
-----------------------------------------
|
| BOB
|
-----------------------------------------
*/

function eBobUpdate()
{

	if (this.invincible == true)
		{								
			this.invincible_time++;
			if (this.invincible_time >= 30) 
				{
					this.invincible = false; 
					this.invincible_time = 0;
				}
		}
	
	if (this.brain[0] == undefined || this.brain[1] == this.brain[2])
		{
			this.brain[0] = Random(0,10)
			this.brain[1] = 0
			this.brain[2] = Random(20,40)
			this.brain[3] = Random(200,400)
			
		}
	
	this.brain[1]++;	
	
	switch (this.brain[0])
		{
			case 0:
				if (this.velocity_x < 1) this.velocity_x += 1
			break;
			
			case 1:
				if (this.velocity_x > -1) this.velocity_x += -1
			break;
			
			case 2:
				if (this.velocity_y < 1) this.velocity_y += 1
			break;
			
			case 3:
				if (this.velocity_y > -1) this.velocity_y += -1
			break;
			case 4:
				if (this.velocity_x < 1) this.velocity_x += 1
				if (this.velocity_y < 1) this.velocity_y += 1
			break;
			
			case 5:
				if (this.velocity_x > -1) this.velocity_x += -1
				if (this.velocity_y < 1) this.velocity_y += 1
			break;
			
			case 6:
				if (this.velocity_x > -1) this.velocity_x += -1
				if (this.velocity_y > -1) this.velocity_y += -1
			break;
			
			case 7:
				if (this.velocity_x > -1) this.velocity_x += -1
				if (this.velocity_y < 1) this.velocity_y += 1
			break;			
		}
		
}

/*
-----------------------------------------
|
| PACE
|
-----------------------------------------
*/

function ePaceUpdate()
{

	if (this.invincible == true)
		{								
			this.invincible_time++;
			if (this.invincible_time >= 30) 
				{
					this.invincible = false; 
					this.invincible_time = 0;
				}
		}
	
	if (this.brain[0] == undefined || this.brain[1] == this.brain[2])
		{
			this.brain[0] = Random(0,3)
			this.brain[1] = 0
			this.brain[2] = Random(10,20)
			this.brain[3] = Random(200,400)
			
		}
	
	this.brain[1]++;	
	
	switch (this.brain[0])
		{
			case 0:
				if (this.velocity_x < 1) this.velocity_x += 1
			break;
			
			case 1:
				if (this.velocity_x > -1) this.velocity_x += -1
			break;
						
		}
		
}

/*
-----------------------------------------
|
| EXIT
|
-----------------------------------------
*/

function eExitTouch(other)
{
	if (other.name == People[Player].name)
		{
			switch (GetCurrentMap())
				{
					case "forest_area.rmp":
						SwapMap("crossroads.rmp",29,713)
					break;
					case "swamp_area.rmp":
						SwapMap("crossroads.rmp",1001,680)
					break;
					case "ruin_area.rmp":
						SwapMap("crossroads.rmp",29,332)
					break;
				}
		}
}

/*
-----------------------------------------
|
| ITEM
|
-----------------------------------------
*/

function eItemTouch(other)
{
	if (other.dead == false)
		{
			this.dead = true;
			other.inventory.push(this.inventory[0])
			Particles.push( new Particle(GetPersonX(this.name),GetPersonY(this.name),
											0,-2,1,"Got "+Item_Database[this.inventory[0]].name+"!",pFlyUp))			
		}
}

function eItemPlayerTouch(other)
{
	if (other.dead == false && other.name == People[Player].name)
		{
			this.dead = true;
			other.inventory.push(this.inventory[0])
			Particles.push( new Particle(GetPersonX(this.name),GetPersonY(this.name),
											0,-2,1,"Got "+Item_Database[this.inventory[0]].name+"!",pFlyUp))			
		}
}

function eGoldTouch(other)
{
	if (other.dead == false)
		{
			this.dead = true;
			//other.inventory.push(this.inventory[0])
			amount = Random(1,this.inventory[0])
			other.gold += amount
			Particles.push( new Particle(GetPersonX(this.name),GetPersonY(this.name),
											0,-2,1,amount+" gold!",pFlyUp))			
		}
}

function eItemHurt(other)
{

}

function eItemUpdate(other)
{

}

/*
-----------------------------------------
|
| ENEMY
|
-----------------------------------------
*/

function eEnemyTouch(other)
{	
	if (this.invincible == false && other.name == People[Player].name) other.hurt(this)
	else
		{
			this.velocity_x = -this.velocity_x
			this.velocity_y = -this.velocity_y
		}
}

function eEnemyHurt(other)
{

										
	if (this.velocity_x != 0 || this.velocity_y != 0) 
		{
			if (this.velocity_x > 0) this.velocity_x = -10
			else { if (this.velocity_x < 0) this.velocity_x = 10 }
			
			if (this.velocity_y > 0) this.velocity_y = -10
			else { if (this.velocity_y < 0) this.velocity_y = 10 }											
		}
	else
		{
			switch (GetPersonDirection(other.name))
				{	
					case "north":
						this.velocity_y = -10
					break; 
					
					case "south":
						this.velocity_y = 10
					break; 
					case "east":
						this.velocity_x = 10
					break; 
					case "west":
						this.velocity_x = -10
					break;													
				}										
		}

	if (this.invincible == false)
		{
			DoDamage(this,other)			
			if (this.hp <= 0) 
				{
					other.xp += this.xp 
					Particles.push( new Particle(GetPersonX(this.name),GetPersonY(this.name),
											0,-2,1,"Gained "+this.xp+" xp!",pFlyUp))
				}
			SetPersonIgnoreList(this.name, [other.name+"_weapon"])
		}
											
}

/*
-----------------------------------------
|
| ORC
|
-----------------------------------------
*/

function eOrcUpdate()
{

	StandardEnemyUpdate(this)
	
	if (this.brain[0] == undefined || this.brain[1] == this.brain[2])
		{
			this.brain[0] = Random(0,12)
			this.brain[1] = 0
			this.brain[2] = Random(20,40)
			this.brain[3] = Random(200,400)
			
		}
	
	if (Random(0,this.brain[3]) == 5) this.state = attack_a
	
	this.brain[1]++;	
	
	switch (this.brain[0])
		{
			case 0:
				if (this.velocity_x < 1) this.velocity_x += 1
			break;
			
			case 1:
				if (this.velocity_x > -1) this.velocity_x += -1
			break;
			
			case 2:
				if (this.velocity_y < 1) this.velocity_y += 1
			break;
			
			case 3:
				if (this.velocity_y > -1) this.velocity_y += -1
			break;
			case 4:
				if (this.velocity_x < 1) this.velocity_x += 1
				if (this.velocity_y < 1) this.velocity_y += 1
			break;
			
			case 5:
				if (this.velocity_x > -1) this.velocity_x += -1
				if (this.velocity_y < 1) this.velocity_y += 1
			break;
			
			case 6:
				if (this.velocity_x > -1) this.velocity_x += -1
				if (this.velocity_y > -1) this.velocity_y += -1
			break;
			
			case 7:
				if (this.velocity_x > -1) this.velocity_x += -1
				if (this.velocity_y < 1) this.velocity_y += 1
			break;			
		}
		
}

/*
-----------------------------------------
|
| TROLL
|
-----------------------------------------
*/

function eTrollUpdate()
{

	StandardEnemyUpdate(this)
	
	if (this.brain[0] == undefined || this.brain[1] == this.brain[2])
		{
			this.brain[0] = Random(0,25)
			this.brain[1] = 0
			this.brain[2] = Random(10,30)
			this.brain[3] = Random(50,100)
			
		}
	
	if (Random(0,this.brain[3]) == 5) this.state = attack_a
	
	this.brain[1]++;	
	
	switch (this.brain[0])
		{
			case 0:
				if (this.velocity_x < 1) this.velocity_x += 1
			break;
			
			case 1:
				if (this.velocity_x > -1) this.velocity_x += -1
			break;
			
			case 2:
				if (this.velocity_y < 1) this.velocity_y += 1
			break;
			
			case 3:
				if (this.velocity_y > -1) this.velocity_y += -1
			break;
			case 4:
				if (this.velocity_x < 1) this.velocity_x += 1
				if (this.velocity_y < 1) this.velocity_y += 1
			break;
			
			case 5:
				if (this.velocity_x > -1) this.velocity_x += -1
				if (this.velocity_y < 1) this.velocity_y += 1
			break;
			
			case 6:
				if (this.velocity_x > -1) this.velocity_x += -1
				if (this.velocity_y > -1) this.velocity_y += -1
			break;
			
			case 7:
				if (this.velocity_x > -1) this.velocity_x += -1
				if (this.velocity_y < 1) this.velocity_y += 1
			break;			
		}
		
}

/*
-----------------------------------------
|
| RABBIT
|
-----------------------------------------
*/

function eRabbitUpdate()
{

	StandardEnemyUpdate(this)
	
	if (this.brain[0] == undefined || this.brain[1] == this.brain[2])
		{
			this.brain[0] = Random(0,15)
			this.brain[1] = 0
			this.brain[2] = Random(5,20)
			this.brain[3] = Random(300,600)
			
		}
	
	if (Random(0,this.brain[3]) == 5) this.state = attack_a
	
	this.brain[1]++;	
	
	switch (this.brain[0])
		{
			case 0:
				if (this.velocity_x < 1) this.velocity_x += 2
			break;
			
			case 1:
				if (this.velocity_x > -1) this.velocity_x += -2
			break;
			
			case 2:
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 3:
				if (this.velocity_y > -1) this.velocity_y += -2
			break;
			case 4:
				if (this.velocity_x < 1) this.velocity_x += 2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 5:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 6:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y > -1) this.velocity_y += -2
			break;
			
			case 7:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;			
		}
		
}

/*
-----------------------------------------
|
| PIT
|
-----------------------------------------
*/

function ePitUpdate()
{

	StandardEnemyUpdate(this)
			
}

/*
-----------------------------------------
|
| PIT
|
-----------------------------------------
*/

function ePitHurt(other)
{

	if (this.invincible == false)
		{
			DoDamage(this,other)			
			if (this.hp <= 0) 
				{
					other.xp += this.xp 
					Particles.push( new Particle(GetPersonX(this.name),GetPersonY(this.name),
											0,-2,1,"Gained "+this.xp+" xp!",pFlyUp))
				}
			SetPersonIgnoreList(this.name, [other.name+"_weapon"])
		}
											
}

/*
-----------------------------------------
|
| TENTACLE
|
-----------------------------------------
*/

function eTentacleUpdate()
{

	StandardEnemyUpdate(this)
	
	if (this.brain[0] == undefined || this.brain[1] == this.brain[2])
		{
			this.brain[0] = Random(0,9)
			this.brain[1] = 0
			this.brain[2] = Random(5,15)
			this.brain[3] = Random(300,600)
			
		}
	
	if (Random(0,this.brain[3]) == 5) this.state = attack_a
	
	this.brain[1]++;	
	
	switch (this.brain[0])
		{
			case 0:
				if (this.velocity_x < 1) this.velocity_x += 2
			break;
			
			case 1:
				if (this.velocity_x > -1) this.velocity_x += -2
			break;
			
			case 2:
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 3:
				if (this.velocity_y > -1) this.velocity_y += -2
			break;
			case 4:
				if (this.velocity_x < 1) this.velocity_x += 2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 5:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 6:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y > -1) this.velocity_y += -2
			break;
			
			case 7:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;			
		}
		
}

/*
-----------------------------------------
|
| AMAZON
|
-----------------------------------------
*/

function eAmazonUpdate()
{

	StandardEnemyUpdate(this)
	
	if (this.brain[0] == undefined || this.brain[1] == this.brain[2])
		{
			this.brain[0] = Random(0,7)
			this.brain[1] = 0
			this.brain[2] = Random(20,40)
			this.brain[3] = Random(10,20)
			
		}
	
	if (Random(0,this.brain[3]) == 5) this.state = attack_a
	
	this.brain[1]++;	
	
	switch (this.brain[0])
		{
			case 0:
				if (this.velocity_x < 1) this.velocity_x += 2
			break;
			
			case 1:
				if (this.velocity_x > -1) this.velocity_x += -2
			break;
			
			case 2:
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 3:
				if (this.velocity_y > -1) this.velocity_y += -2
			break;
			case 4:
				if (this.velocity_x < 1) this.velocity_x += 2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 5:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 6:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y > -1) this.velocity_y += -2
			break;
			
			case 7:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;			
		}
		
}

/*
-----------------------------------------
|
| MIMIC
|
-----------------------------------------
*/

function eMimicUpdate()
{

	StandardEnemyUpdate(this)
	
	if (this.brain[4] == true)
		{
	
			if (this.brain[0] == undefined || this.brain[1] == this.brain[2])
				{
					this.brain[0] = Random(0,7)
					this.brain[1] = 0
					this.brain[2] = Random(20,40)
					this.brain[3] = Random(10,20)
					
				}
			
			if (Random(0,this.brain[3]) == 5) this.state = attack_a
			
			this.brain[1]++;	
			
			switch (this.brain[0])
				{
					case 0:
						if (this.velocity_x < 1) this.velocity_x += 2
					break;
					
					case 1:
						if (this.velocity_x > -1) this.velocity_x += -2
					break;
					
					case 2:
						if (this.velocity_y < 1) this.velocity_y += 2
					break;
					
					case 3:
						if (this.velocity_y > -1) this.velocity_y += -2
					break;
					case 4:
						if (this.velocity_x < 1) this.velocity_x += 2
						if (this.velocity_y < 1) this.velocity_y += 2
					break;
					
					case 5:
						if (this.velocity_x > -1) this.velocity_x += -2
						if (this.velocity_y < 1) this.velocity_y += 2
					break;
					
					case 6:
						if (this.velocity_x > -1) this.velocity_x += -2
						if (this.velocity_y > -1) this.velocity_y += -2
					break;
					
					case 7:
						if (this.velocity_x > -1) this.velocity_x += -2
						if (this.velocity_y < 1) this.velocity_y += 2
					break;			
				}
		}
}

/*
-----------------------------------------
|
| MIMIC
|
-----------------------------------------
*/

function eMimicTouch(other)
{	

	this.brain[4] = true;

	if (this.invincible == false) other.hurt(this)
	else
		{
			this.velocity_x = -this.velocity_x
			this.velocity_y = -this.velocity_y
		}
}

/*
-----------------------------------------
|
| MIMIC
|
-----------------------------------------
*/

function eMimicHurt(other)
{
	
	this.brain[4] = true;
										
	if (this.velocity_x != 0 || this.velocity_y != 0) 
		{
			if (this.velocity_x > 0) this.velocity_x = -10
			else { if (this.velocity_x < 0) this.velocity_x = 10 }
			
			if (this.velocity_y > 0) this.velocity_y = -10
			else { if (this.velocity_y < 0) this.velocity_y = 10 }											
		}
	else
		{
			switch (GetPersonDirection(other.name))
				{	
					case "north":
						this.velocity_y = -10
					break; 
					
					case "south":
						this.velocity_y = 10
					break; 
					case "east":
						this.velocity_x = 10
					break; 
					case "west":
						this.velocity_x = -10
					break;													
				}										
		}

	if (this.invincible == false)
		{
			DoDamage(this,other)			
			if (this.hp <= 0) 
				{
					other.xp += this.xp 
					Particles.push( new Particle(GetPersonX(this.name),GetPersonY(this.name),
											0,-2,1,"Gained "+this.xp+" xp!",pFlyUp))
				}
			SetPersonIgnoreList(this.name, [other.name+"_weapon"])
		}
											
}

/*
-----------------------------------------
|
| CROW
|
-----------------------------------------
*/

function eCrowUpdate()
{

	if (this.brain[5] == undefined) { IgnoreTileObstructions(this.name, true); this.brain[5] = true; }

	StandardEnemyUpdate(this)
	
	if (this.brain[0] == undefined || this.brain[1] == this.brain[2])
		{
			this.brain[0] = Random(0,7)
			this.brain[1] = 0
			this.brain[2] = Random(10,30)
			this.brain[3] = Random(40,80)
			
		}
	
	if (Random(0,this.brain[3]) == 5) this.state = attack_a
	
	this.brain[1]++;	
	
	switch (this.brain[0])
		{
			case 0:
				if (this.velocity_x < 1) this.velocity_x += 2
			break;
					
			case 1:
				if (this.velocity_x > -1) this.velocity_x += -2
			break;
					
			case 2:
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
					
			case 3:
				if (this.velocity_y > -1) this.velocity_y += -2
			break;		
			
			case 4:
				if (this.velocity_x < 1) this.velocity_x += 2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 5:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 6:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y > -1) this.velocity_y += -2
			break;
			
			case 7:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;			
		}
		
}

/*
-----------------------------------------
|
| PIG
|
-----------------------------------------
*/

function ePigUpdate()
{

	if (this.brain[5] == undefined) { IgnoreTileObstructions(this.name, true); this.brain[5] = true; }

	StandardEnemyUpdate(this)
	
	if (this.brain[4] == true)
		{
	
			if (this.brain[0] == undefined || this.brain[1] == this.brain[2])
				{
					this.brain[0] = Random(0,7)
					this.brain[1] = 0
					this.brain[2] = Random(20,40)
					this.brain[3] = Random(10,20)
					
				}
			
			if (Random(0,this.brain[3]) == 5) this.state = attack_a
			
			this.brain[1]++;	
			
			switch (this.brain[0])
				{
					case 0:
						if (this.velocity_x < 1) this.velocity_x += 2
					break;
					
					case 1:
						if (this.velocity_x > -1) this.velocity_x += -2
					break;
					
					case 2:
						if (this.velocity_y < 1) this.velocity_y += 2
					break;
					
					case 3:
						if (this.velocity_y > -1) this.velocity_y += -2
					break;
					case 4:
						if (this.velocity_x < 1) this.velocity_x += 2
						if (this.velocity_y < 1) this.velocity_y += 2
					break;
					
					case 5:
						if (this.velocity_x > -1) this.velocity_x += -2
						if (this.velocity_y < 1) this.velocity_y += 2
					break;
					
					case 6:
						if (this.velocity_x > -1) this.velocity_x += -2
						if (this.velocity_y > -1) this.velocity_y += -2
					break;
					
					case 7:
						if (this.velocity_x > -1) this.velocity_x += -2
						if (this.velocity_y < 1) this.velocity_y += 2
					break;			
				}
		}
}

/*
-----------------------------------------
|
| FISH
|
-----------------------------------------
*/

function eFishUpdate()
{

	StandardEnemyUpdate(this)
	
	if (this.brain[0] == undefined || this.brain[1] == this.brain[2])
		{
			this.brain[0] = Random(0,10)
			this.brain[1] = 0
			this.brain[2] = Random(5,8)
			this.brain[3] = Random(200,400)
			
		}
	
	if (Random(0,this.brain[3]) == 5) this.state = attack_a
	
	this.brain[1]++;	
	
	switch (this.brain[0])
		{
			case 0:
				if (this.velocity_x < 1) this.velocity_x += 2
			break;
			
			case 1:
				if (this.velocity_x > -1) this.velocity_x += -2
			break;
			
			case 2:
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 3:
				if (this.velocity_y > -1) this.velocity_y += -2
			break;
			case 4:
				if (this.velocity_x < 1) this.velocity_x += 2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 5:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;
			
			case 6:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y > -1) this.velocity_y += -2
			break;
			
			case 7:
				if (this.velocity_x > -1) this.velocity_x += -2
				if (this.velocity_y < 1) this.velocity_y += 2
			break;			
		}
		
}

/*
-----------------------------------------
|
| MUMMY
|
-----------------------------------------
*/

function eMummyUpdate()
{

	StandardEnemyUpdate(this)
	
	if (this.brain[0] == undefined || this.brain[1] == this.brain[2])
		{
			this.brain[0] = Random(0,20)
			this.brain[1] = 0
			this.brain[2] = Random(40,80)
			this.brain[3] = Random(100,200)
			
		}
	
	if (Random(0,this.brain[3]) == 5) this.state = attack_a
	
	this.brain[1]++;	
	
	switch (this.brain[0])
		{
			case 0:
				if (this.velocity_x < 1) this.velocity_x += .5
			break;
			
			case 1:
				if (this.velocity_x > -1) this.velocity_x += -.5
			break;
			
			case 2:
				if (this.velocity_y < 1) this.velocity_y += .5
			break;
			
			case 3:
				if (this.velocity_y > -1) this.velocity_y += -.5
			break;
			case 4:
				if (this.velocity_x < 1) this.velocity_x += .5
				if (this.velocity_y < 1) this.velocity_y += .5
			break;
			
			case 5:
				if (this.velocity_x > -1) this.velocity_x += -.5
				if (this.velocity_y < 1) this.velocity_y += .5
			break;
			
			case 6:
				if (this.velocity_x > -1) this.velocity_x += -.5
				if (this.velocity_y > -1) this.velocity_y += -.5
			break;
			
			case 7:
				if (this.velocity_x > -1) this.velocity_x += -.5
				if (this.velocity_y < 1) this.velocity_y += .5
			break;			
		}
		
}

/*
-----------------------------------------
|
| BEE
|
-----------------------------------------
*/

function eBeeUpdate()
{

	if (this.brain[5] == undefined) { IgnoreTileObstructions(this.name, true); this.brain[5] = true; }

	StandardEnemyUpdate(this)
	
	if (this.brain[0] == undefined || this.brain[1] == this.brain[2])
		{
			this.brain[0] = Random(0,7)
			this.brain[1] = 0
			this.brain[2] = Random(10,20)
			this.brain[3] = Random(40,80)
			
		}
	
	if (Random(0,this.brain[3]) == 5) this.state = attack_a
	
	this.brain[1]++;	
	
	switch (this.brain[0])
		{
			case 0:
				if (this.velocity_x < 1) this.velocity_x += 3
			break;
					
			case 1:
				if (this.velocity_x > -1) this.velocity_x += -3
			break;
					
			case 2:
				if (this.velocity_y < 1) this.velocity_y += 3
			break;
					
			case 3:
				if (this.velocity_y > -1) this.velocity_y += -3
			break;		
			
			case 4:
				if (this.velocity_x < 1) this.velocity_x += 3
				if (this.velocity_y < 1) this.velocity_y += 3
			break;
			
			case 5:
				if (this.velocity_x > -1) this.velocity_x += -3
				if (this.velocity_y < 1) this.velocity_y += 3
			break;
			
			case 6:
				if (this.velocity_x > -1) this.velocity_x += -3
				if (this.velocity_y > -1) this.velocity_y += -3
			break;
			
			case 7:
				if (this.velocity_x > -1) this.velocity_x += -3
				if (this.velocity_y < 1) this.velocity_y += 3
			break;			
		}
		
}

/*
-----------------------------------------
|
| STANDARD ENEMY
|
-----------------------------------------
*/

function StandardEnemyUpdate(thiss)
{
	if (thiss.hp <= 0) 
		{
		
			if (thiss.inventory != undefined)
				{
					item = thiss.inventory[Random(0,thiss.inventory.length-1)]
					if (Random(0,Item_Database[item].odds) == 0)
						 {
								People.push( new Person("item"+Math.random(),
															Item_Database[item].sprite,
															eItemTouch,
															eItemHurt,
															eItemUpdate,
															GetPersonX(thiss.name),
															GetPersonY(thiss.name),
															true))		
								People[People.length-1].inventory = [item]
						}
				}
						
			thiss.dead = true 

		
		}

								
	if (thiss.invincible == true)
		{
			if (Math.sin(GetTime()>>6) > 0)
				{								 
					SetPersonMask(thiss.name, CreateColor(255,128,128))
				}
			else
				{
					SetPersonMask(thiss.name, CreateColor(255,255,255))
				}										
			thiss.invincible_time++;
			if (thiss.invincible_time >= 30) 
				{
					thiss.invincible = false; 
					thiss.invincible_time = 0;
					SetPersonIgnoreList(thiss.name, [])
				}
		}
	else
		{
			SetPersonMask(thiss.name, CreateColor(255,255,255))
		}
		
}

/*
-----------------------------------------
|
| RESTOCK SHOPS
|
-----------------------------------------
*/

function RestockShops()
{
	for (var i = 0; i < People.length; i++)
		{
			if (People[i].name == "Oliver")
				{
					switch (GetPlayerLevel())
						{
							case 0:
								amount = 8
								items = [0,0,0,2,5,7,11]
							break;
							case 1:
								amount = 10
								items = [0,1,1,1,19,20,11]
							break;
							case 2: 
								amount = 12
								items = [1,31,31,31,19,5,11]
							break;
							case 3: 
								amount = 14
								items = [31,32,32,30,8,9,11,19,5,2,5]; 
							break;								
						}	
						
					StockInv(amount,items,i)
					
				}
			if (People[i].name == "Wolfgang")
				{
					switch (GetPlayerLevel())
						{
							case 0:
								amount = 10
								items = [34,34,34,35,35,35,35,36]
							break;
							case 1:
								amount = 15
								items = [34,34,34,35,35,35,35,36,39,37,40,43,44,]
							break;
							case 2: 
								amount = 20
								items = [34,34,34,35,35,35,35,36,39,37,40,43,43,44,44,41,42]
							break;
							case 3: 
								amount = 30
								items = [34,34,35,35,35,36,39,37,40,43,43,44,44,41,42,45,46,47]; 
							break;								
						}	
						
					StockInv(amount,items,i)
					
				}				
		}
}

function StockInv(amount,items,i)
{
					a = Random(4,amount)
					for (var i2 = 0; i2 < a; i2++)
						{
							People[i].inventory.push ( items[ Random(0,items.length-1) ] )
						}
						
					if (People[i].inventory.length >= 3)
						 {
								a = Random(0,3)	
								for (var i2 = 0; i2 < a; i2++)
									{						
										People[i].inventory.splice ( Random(0,People[i].inventory.length-1), 1 )
									}
							}
}

/*
-----------------------------------------
|
| SWITCHES
|
-----------------------------------------
*/

function DoSwitchUpdate(other)
{
	if (this.invincible == true)
		{
			if (Math.sin(GetTime()>>6) > 0)
				{								 
					SetPersonMask(this.name, CreateColor(255,128,128))
				}
			else
				{
					SetPersonMask(this.name, CreateColor(255,255,255))
				}										
			this.invincible_time++;
			if (this.invincible_time >= 30) 
				{
					this.invincible = false; 
					this.invincible_time = 0;
				}
		}
	else
		{
			SetPersonMask(this.name, CreateColor(255,255,255))
		}
}

function DoSwitchHurt(other)
{
	if (Flag[this.str] != true && other.name == People[Player].name)
		{
			this.invincible = true
			Flag[this.str] = true
		}
}

function DoRockHurt(other)
{
	if (other.name == People[Player].name && other.weapon_number == 54)
		{
			this.dead = true
		}
}

function DoBlockadeUpdate(other)
{
	if (Flag[this.str] == true) this.dead = true
}

function AddSwitch(x,y,n)
{
	People.push( new Person("switch"+Math.random(),
		"switch.rss",DoNothing,DoSwitchHurt,DoSwitchUpdate,x,y,true) )

	People[People.length-1].str = n
	People[People.length-1].thing = -1
}

function AddBlockade(x,y,n)
{
	People.push( new Person("blockade"+Math.random(),
		"blockade.rss",DoNothing,DoNothing,DoBlockadeUpdate,x,y,true) )

	People[People.length-1].str = n
	People[People.length-1].thing = -1
}

function AddRockBlockade(x,y)
{
	People.push( new Person("rock"+Math.random(),
		"rock.rss",DoNothing,DoRockHurt,DoNothing,x,y,true) )

	People[People.length-1].thing = -1
}

function DoDungeon1ExitTouch(other)
{
	SwapMap("boss1.rmp")
}

/*
-----------------------------------------
|
| SHOOTER ENEMYS
|
-----------------------------------------
*/

function eSEnemyTouch(other)
{	
	if (this.invincible == false && other.name == People[Player].name && other.invincible == false)
		{
			other.invincible=true
			other.hp--;
			if (other.brain[10] > 1) other.brain[10]--;
			other.velocity_y = -other.velocity_y 
			other.velocity_x = -other.velocity_x
		}
	else
		{
			this.velocity_x = -this.velocity_x
			this.velocity_y = -this.velocity_y
		}
}

function eSEnemyHurt(other)
{

	if (this.invincible == false && other.name == People[Player].name)
		{
			this.hp--;	
			if (this.name == "khamosis") this.invincible=true	
			if (this.hp <= 0) 
				{	
					this.dead=true
					other.xp += this.xp 
					Particles.push( new Particle(GetPersonX(this.name),GetPersonY(this.name),
											0,-4,1,"Gained "+this.xp+" xp!",pFlyUp))
				}
			SetPersonIgnoreList(this.name, [other.name+"_weapon"])
		}
		
	if (this.hp <=0 && this.name == "khamosis") Flag[7] = true;
											
}

function eSPlayerHurt(other)
{
	if (this.invincible==false)
		{
			if (this.brain[10] > 1) this.brain[10]--;
			this.hp--
			this.invincible=true
			if (this.hp<=0)this.dead=true
		}
											
}

function ePowerupTouch(other)
{	
	if (other.name == People[Player].name) 
		{
			if (other.brain[10] < 4 && other.invincible == false)
				{
					other.invincible=true
					Particles.push( new Particle(GetPersonX(this.name),GetPersonY(this.name),
											0,-4,1,"Powerup get!",pFlyUp))		
					other.brain[10]++
					this.dead=true
				}
		}
}

function ePowerupUpdate()
{
	//SetPersonY(this.name, GetPersonY(this.name) + 2)
}